/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include "metypes.h"

typedef struct
{
    int     x;
    int     y;
} VECTOR;

/* --- macroblock stuff --- */
#define MODE_INTER		0
#define MODE_INTER_Q	1
#define MODE_INTER4V	2
#define	MODE_INTRA		3
#define MODE_INTRA_Q	4
#define MODE_STUFFING	7
#define MODE_NOT_CODED	16

#define MB_SIZE 16

typedef struct
{
    //uint32  MTB;
    uint32  bufa;
    uint32  bufb;
    uint32  buf;
    uint32  pos;
    uint32 *tail;
    uint32 *start;
    uint32  length;
}
Bitstream;

#define MBPRED_SIZE  15

typedef struct
{
    VECTOR  mvs[4];
    uint32  sad8[4];      /* SAD values for inter4v-VECTORs */

    short int pred_values[6][MBPRED_SIZE];
    int    acpred_directions[6];

    int    mode;
    int    quant;        /* absolute quant */
} MACROBLOCK;

static  int32
get_dc_scaler(int32 quant, uint32 lum)
{
    int32   dc_scaler;

    if (quant > 0 && quant < 5)
    {
        dc_scaler = 8;
        return dc_scaler;
    }

    if (quant < 25 && !lum)
    {
        dc_scaler = (quant + 13) >> 1;
        return dc_scaler;
    }

    if (quant < 9)
    {
        dc_scaler = quant << 1;
        return dc_scaler;
    }

    if (quant < 25)
    {
        dc_scaler = quant + 8;
        return dc_scaler;
    }

    if (lum)
    {
        dc_scaler = (quant << 1) - 16;
    }
    else
    {
        dc_scaler = quant - 6;
    }

    return dc_scaler;
}

#endif /* _GLOBAL_H_ */
